unit TRTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,IEEEDEL,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    lblResponse: TLabel;
    txtAddr: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    optIdentify: TRadioButton;
    optRead: TRadioButton;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var status: integer;
var response,sendStr: string;
var len : word;
begin
lblResponse.caption := '  '; // blank out old data in the label

initialize (21,0); // initialize the GPIB interface usually done at program init
settimeout(1000);  // set timeout to 1 sec

if optIdentify.Checked = True then // determine what command to send
        sendStr := '*IDN?'
        else
        sendStr := ':READ?';

send (StrToInt(txtAddr.Text), sendStr, status);  // send command to desired address

enter (response, 80, len, StrToInt(txtAddr.Text), status);

if status <> 0 then
           lblResponse.Caption := 'Error Number: ' + IntToStr(status)
           else
       // response,maxChar,length,address,status
        lblResponse.Caption := response;

{
  If your instrument gives a -213 error when sending the :READ? command
  it only means that the "Init was ignored".  Most DMM products from Keithley
  will automatically trigger new readings when in remote (in contrast to
  Agilent products).  So the SCPI command of :READ? (:Abort, Init, Fetch)
  sends an unnecessary Init command.....which is ignored.

  You can avoid the -213 by sending instead the Fetch command, or by turning
  off the continuous init by sending :INIT:CONT OFF or by sending *RST
}

end;

end.
